rem 
rem $Header: cursor.sql,v 1.1 1994/10/10 18:57:41 cracicot Exp $ 
rem 
Rem  Copyright (c) 1992 by Oracle Corporation 
Rem    NAME
Rem      cursor.sql - sql script generates stored package for cursor demo
Rem    MODIFIED   (MM/DD/YY)
Rem     cracicot   10/10/94 -  Creation

-- Stored package that is part
-- of a sample program set that demonstrates how
-- to use cursor variables.
-- This package contains
--   the cursor declaration, in the package spec
--   the OPEN1 procedure that is called by the driver
--     program to open the cursor

-- The other files in this set are:
-- dcursor.c:  the C program that calls the
--             module procedures and the OPEN1 procedure
-- cursor.mc:  the source for the module

-- To gain access to the OPEN1 procedure from the C driver
-- program, you must run SQL*Module to generate the stub.
-- Do this using the command:
--  modc pname=CURSOR_VAR_PKG rpc=yes user=scott/tiger bind=late oname=CURSORP

CONNECT scott/tiger

DROP VIEW emp_view;
CREATE VIEW emp_view AS SELECT ename FROM emp;

CREATE OR REPLACE PACKAGE cursor_var_pkg AS

    TYPE curtype IS REF CURSOR RETURN emp_view%ROWTYPE;

    PROCEDURE OPEN1(cur1 IN OUT curtype)
        WITH INTERFACE PROCEDURE OPEN1 (SQLCODE integer, cur1 SQL_CURSOR);

end cursor_var_pkg;
/

CREATE OR REPLACE PACKAGE BODY cursor_var_pkg AS

    PROCEDURE OPEN1(cur1 IN OUT curtype) IS
    BEGIN
        OPEN cur1 FOR SELECT ename FROM emp_view;
    END;
END cursor_var_pkg;
/

COMMIT;

